<?php
/**
 * @version     1.0.0
 * @package     mod_tlpteam
 * @copyright   Copyright (C) 2013. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TechLabPro <techlabpro@gmail.com> - http://www.techlabpro.com
 */
// no direct access
defined('_JEXEC') or die;

$app = JFactory::getApplication();
$input = $app ->input;
$tlpteam_params = JComponentHelper::getParams('com_tlpteam');
$image_storiage_path    = $tlpteam_params->get('image_path','images/tlpteam');
$image_storiage_folder  = JPATH_ROOT.'/'. $image_storiage_path.'/';
//This is the parameter we get from the XML file


$showno= $params->get('showno');
$speed= $params->get('speed');
$autoplay= $params->get('autoplay');
$navigation= $params->get('navigation');
$pagination= $params->get('pagination');
$responsive= $params->get('responsive');
$lazyload= $params->get('lazyload');
$shortbio= $params->get('shortbio');
$shortbiolimit= $params->get('shortbiolimit');
$enablejquery= $params->get('enablejquery');
$teammenuitem= $params->get('teammenuitem');

?>
  <div id="tlp-team-module" class="owl-carousel owl-theme">
     <?php
    foreach ($rows as $row){
	?>

        <div class="item">
              <?php
      		if (!empty($row->profile_image)){ ?>
      			<a href="<?php echo JRoute::_('index.php?option=com_tlpteam&view=team&id='.(int) $row->id.'&Itemid='.$teammenuitem); ?>"><img src="<?php echo JURI::root().$image_storiage_path.'/m_'.$row->profile_image;?>" /></a>
      			<?php
      		}else{ ?>
              	<img class="hwllow" src="<?php echo JURI::root().$image_storiage_path?>noimage.jpg" alt="noimage" />
              <?php }?>
        		<div class="tlp-team-name">
                <h3><a href="<?php echo JRoute::_('index.php?option=com_tlpteam&view=team&id='.(int)$row->id.'&Itemid='.$teammenuitem); ?>">
      				<?php echo $row->name; ?></a></h3></div>
               <div class="tlp-team-position"><h4><?php echo $row->position; ?></h4></div>
               <?php if($shortbio=='true'){?>
               <div class="tlp-team-short-bio"><?php echo substr($row->short_bio,0,$shortbiolimit) ?></div>
               <?php }?>
               <div class="tlp-team-social">
                 <ul>
                   <?php if($row->facebook!=''){?><li ><a class="tlp-facebook-icon"  href="<?php echo $row->facebook;?>" target="_new">facebook </a></li><?php }?>
                   <?php if($row->twitter!=''){?><li ><a  class="tlp-twitter-icon" href="<?php echo $row->twitter;?>" target="_new">twitter</a></li><?php }?>
                   <?php if($row->googleplus!=''){?><li ><a  class="tlp-googleplus-icon" href="<?php echo $row->googleplus;?>" target="_new">googleplus </a></li><?php }?>
                   <?php if($row->linkedin!=''){?><li ><a  class="tlp-linkedin-icon" href="<?php echo $row->linkedin;?>" target="_new">linkedin</a></li><?php }?>
                 </ul>


               </div>
               <div class="tlp-cb"></div>
        </div>


     <?php } ?>

    </div>

<script type="text/javascript">
  (function ($) {
    var owl = $("#tlp-team-module");
    owl.owlCarousel({
      autoplay: <?php echo $params->get( 'autoplay' );?>,
      navText: ['<i class="fa fa-chevron-left"></i>', '<i class="fa fa-chevron-right"></i>'],
      nav: <?php echo $params->get( 'navigation' );?>,
      dots: <?php echo $params->get( 'pagination' );?>,
      lazyLoad: <?php echo $params->get( 'lazyload' );?>,
      loop: true,
      smartSpeed: <?php echo $params->get( 'speed' );?>,
      margin: 30,
      autoHeight: true,
      responsiveClass: true,
      responsive: {
        0: {
          items: 1,
          nav: <?php echo $params->get( 'navigation' );?>,
          dots: <?php echo $params->get( 'pagination' );?>
        },
        480: {
          items: 1,
          nav: <?php echo $params->get( 'navigation' );?>,
          dots: <?php echo $params->get( 'pagination' );?>
        },
        // breakpoint from 768 up
        768: {
          items: <?php echo $params->get( 'showno' );?>,
          nav: <?php echo $params->get( 'navigation' );?>,
          dots: <?php echo $params->get( 'pagination' );?>
        },
        // breakpoint from 768 up
        1200: {
          items: <?php echo $params->get( 'showno' );?>,
          nav: <?php echo $params->get( 'navigation' );?>,
          dots: <?php echo $params->get( 'pagination' );?>
        }
      }
    });
  })(jQuery);   
</script>