<?php

/**
 * @version     2.0
 * @package     com_tlpportfolio
 * @subpackage  mod_tlpportfolio
 * @author      TechLabPro <mamunnu@gmail.com>
 * @copyright   Copyright (C) 2015. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
$rows = ModTlpportfolioHelper::getList($params);
$app = JFactory::getApplication();
$tlpportfolio_params = JComponentHelper::getParams('com_tlpportfolio');
$image_storiage_path = $tlpportfolio_params->get('image_path');
$layout 			 = $tlpportfolio_params->get('layout');
$display_no 	 	 = $params->get('mod_showno');
$link_detail 		 = $tlpportfolio_params->get('link_detail');
$grid				 = (12/$display_no);

$bss="tlp-col-md-".$grid." tlp-col-lg-".$grid." tlp-col-sm-6";


if($display_no==2){
    $image_area="tlp-col-md-5 tlp-col-lg-5 tlp-col-sm-6 paddingl0";
    $content_area="tlp-col-md-7 tlp-col-lg-7 tlp-col-sm-6 paddingr0";
}else{
    $image_area="tlp-col-md-3 tlp-col-lg-3 tlp-col-sm-12 paddingl0";
    $content_area="tlp-col-md-9 tlp-col-lg-9 tlp-col-sm-12 paddingr0";
}
        

?>

<?php if (!empty($rows)) : ?>
<div class="tlp-row tlp-portfolio">
<div class="layout3">
<!-- Layout 3 overlay with name, position, short bio, contact info and social icon-->
	<div class="button-group filter-button-group isotop-btn">
	<button data-filter="*" class="selected">show all</button>
	<?php $category=TlpportfolioFrontendHelper::getCategoryName();
		foreach ($category as $key => $value) {
			echo '<button data-filter=".'.$value->id.'">'.$value->title.'</button>';
		}
	?>
	</div>
	<div class="grid">
<?php 
	foreach ($rows as &$item) {
			$detail_link=JRoute::_('index.php?option=com_tlpportfolio&view=portfolio&id='.(int) $item->id);
			 ?>
		<div class="tlp-portfolio-item <?php echo $item->category.' '.$bss;?> margin-bottom30 tlp-equal-height">               	
            <div class="tlp-portfolio-thum tlp-item">
            	<?php if (!empty($item->portfolio_image)){?>
			    	<figure>
			 			<img class="tlp-img-responsive" src="<?php echo JURI::root().$image_storiage_path.'/m_'.$item->portfolio_image; ?> " alt="<?php echo $item->title; ?>"/>		     		
			 		</figure>	
			    <?php }?>
                	<div class="tlp-overlay">
                        <div class="tlp-content">
                        	<?php if($link_detail==1){?>
					        	    <h3><a href="<?php echo $detail_link;?>"><?php echo $item->title; ?></a></h3>
						          <?php }else{?>
						               <h3><?php echo $item->title; ?></h3>
						          <?php }?>
						          <?php if($item->short_description!=''){?>
						        	<p><?php echo $item->short_description; ?></p>
					          <?php }?>
                         </div>                            
                          <ul class="link-icon-isotop">
                               <?php if($link_detail==1){?>
			                   <li><a href="<?php echo $detail_link;?>"><i class="fa fa-info"></i></a></li>
			                   <?php }?>
			                   <?php if($item->project_url){?>
			                   <li><a href="<?php echo $item->project_url;?>" target="_New"><i class="fa fa-external-link"></i></a></li>  
			                   <?php }?>
                          </ul>            	  
                	</div>
                </div>
                        
        </div>
<?php } ?>
</div>
</div>
</div>
<?php endif;?>

<script src="<?php echo JURI::root();?>components/com_tlpportfolio/assets/js/imagesloaded.pkgd.min.js" type="text/javascript"></script>
<script src="<?php echo JURI::root();?>components/com_tlpportfolio/assets/js/isotope.pkgd.min.js" type="text/javascript"></script>

<script type="text/javascript">

	(function($){
		var $isotop = $('.grid').imagesLoaded( function() {
			$isotop.isotope({
				  // options
				  itemSelector: '.tlp-portfolio-item',
				  layoutMode: 'fitRows'
				});
			});

		 $('.filter-button-group').on( 'click', 'button', function() {
		   var filterValue = $(this).attr('data-filter');
		   $isotop.isotope({ filter: filterValue });
		   $(this).parent().find('.selected').removeClass('selected');
		   $(this).addClass('selected'); 
		 });

        $( ".tlp-portfolio").imagesLoaded(function () {
            var maxH=0;
            $( ".tlp-portfolio .tlp-equal-height" ).each(function( ) {
                var cH = $(this).outerHeight();
                if(cH > maxH){
                    maxH = cH;
                }
                console.log(maxH);
            });

            $(".tlp-portfolio .tlp-equal-height" ).css('height',maxH+"px");
        });

		$('.tlp-item').each(function() {
	      var holder_height = $(this).height();
	      var a_height = $(this).find('.tlp-overlay .link-icon').height();
	      var h = (holder_height - a_height) / 2;
	      $(this).find('.link-icon').css('margin-top', h+'px');
	      }); 

	})(jQuery);

	</script>