<?php
/**
 * @version     2.0
 * @package     com_tlpteam
 * @copyright   Copyright (C) 2013. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TechLabPro <techlabpro@gmail.com> - http://www.techlabpro.com
 */
// no direct access
defined('_JEXEC') or die;
JHtml::_('bootstrap.framework');
JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
//JHtml::_('bootstrap.tooltip');
//JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user = JFactory::getUser();
$userId = $user->get('id');
$listOrder = $this->state->get('list.ordering');
$listDirn = $this->state->get('list.direction');
$canCreate = $user->authorise('core.create', 'com_tlpteam');
$canEdit = $user->authorise('core.edit', 'com_tlpteam');
$canCheckin = $user->authorise('core.manage', 'com_tlpteam');
$canChange = $user->authorise('core.edit.state', 'com_tlpteam');
$canDelete = $user->authorise('core.delete', 'com_tlpteam');

$app = JFactory::getApplication();
$input = $app ->input;
$tlpteam_params = JComponentHelper::getParams('com_tlpteam');
$image_storiage_path    = $tlpteam_params->get('image_path','images/tlpteam');
$image_storiage_folder  = JPATH_ROOT.'/'. $image_storiage_path.'/';


$display_no= $tlpteam_params->get('display_no','4');
$grid=(12/$display_no);
$bss = 'rt-col-lg-'.$grid. ' rt-col-md-'.$grid. ' rt-col-sm-6 rt-col-xs-12';
?>

<form action="<?php echo JRoute::_('index.php?option=com_tlpteam&view=teams'); ?>" method="post" name="adminForm" id="adminForm">

<?php echo JLayoutHelper::render('default_filter', array('view' => $this), dirname(__FILE__)); ?>
<?php if (isset($this->items[0]->state)): ?>
<?php echo JHtml::_('grid.sort', '', 'a.state', $listDirn, $listOrder); ?>
<?php endif; ?>
<div class="tlp-team-list container-fluid">
  <div class="rt-row">
  <?php

  foreach ($this->items as $i => $item) : $i++;

  ?>

  <div class="<?php echo $bss;?> tlp-each-item">
    <?php
    if (!empty($item->profile_image)){ ?>
    <a href="<?php echo JRoute::_('index.php?option=com_tlpteam&view=team&id='.(int) $item->id); ?>"><img src="<?php echo JURI::root().$image_storiage_path.'/l_'.$item->profile_image;?>" /></a>
    <?php
    }else{ ?>
    <img src="<?php echo JURI::root().$image_storiage_path?>noimage.jpg" alt="noimage" />
    <?php }?>
    <div class="tlp-team-name"><h3><a href="<?php echo JRoute::_('index.php?option=com_tlpteam&view=team&id='.(int) $item->id); ?>">
    <?php echo $this->escape($item->name); ?></a></h3>
    </div>
    <div class="tlp-team-position"><h4><?php echo $item->position; ?></h4></div>
    <div class="tlp-team-short-bio-com"><?php echo $item->short_bio; ?></div>
    <div class="tlp-team-social">
      <ul>
      <?php if($item->facebook!=''){?><li ><a class="tlp-facebook-icon"  href="<?php echo $item->facebook;?>" target="_new">facebook </a></li><?php }?>
      <?php if($item->twitter!=''){?><li ><a  class="tlp-twitter-icon" href="<?php echo $item->twitter;?>" target="_new">twitter</a></li><?php }?>
      <?php if($item->googleplus!=''){?><li ><a  class="tlp-googleplus-icon" href="<?php echo $item->googleplus;?>" target="_new">googleplus </a></li><?php }?>
      <?php if($item->linkedin!=''){?><li ><a  class="tlp-linkedin-icon" href="<?php echo $item->linkedin;?>" target="_new">linkedin</a></li><?php }?>
      </ul>
    </div>
  </div>
  <?php endforeach; ?>
  </div>
<div class="rt-row rt-pagination">
  <?php echo $this->pagination->getListFooter(); ?>
</div>

</div>



<input type="hidden" name="task" value=""/>
<input type="hidden" name="boxchecked" value="0"/>
<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>"/>
<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>"/>
<?php echo JHtml::_('form.token'); ?>
</form>
<script src="components/com_tlpteam/assets/js/form.js" type="text/javascript"></script>
