<?php
/**
 * @version    2.0
 * @package    com_tlpportfolio
 * @author     TechLabPro <mamunnu@gmail.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;
JHtml::_('bootstrap.framework');
JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
//JHtml::_('bootstrap.tooltip');
$document = JFactory::getDocument();

$user       = JFactory::getUser();
$userId     = $user->get('id');
$listOrder  = $this->state->get('list.ordering');
$listDirn   = $this->state->get('list.direction');
$canCreate  = $user->authorise('core.create', 'com_tlpportfolio');
$canEdit    = $user->authorise('core.edit', 'com_tlpportfolio');
$canCheckin = $user->authorise('core.manage', 'com_tlpportfolio');
$canChange  = $user->authorise('core.edit.state', 'com_tlpportfolio');
$canDelete  = $user->authorise('core.delete', 'com_tlpportfolio');

$app = JFactory::getApplication();
$tlpportfolio_params = JComponentHelper::getParams('com_tlpportfolio');
$image_storiage_path 	= $tlpportfolio_params->get('image_path');
$g_layout 				= $tlpportfolio_params->get('layout');
$g_display_no 			= $tlpportfolio_params->get('display_no');
$link_detail 			= $tlpportfolio_params->get('link_detail');


// get the menu parameters for use
$app = JFactory::getApplication();
$menu = $app->getMenu();
$active = $menu->getActive();
$itemId = $active->id;
$menuparams         	= $menu->getParams($itemId);
$m_display_no 			= $menuparams->get("m_display_no");
$m_layout 				= $menuparams->get("m_layout");

if($m_layout!=''){ 
	$layout=$m_layout;
}else{
	$layout=$g_layout;
}
if($m_display_no!=''){
	$display_no=$m_display_no;$grid=(12/$m_display_no);
}else{
	$display_no=$g_display_no;$grid=(12/$g_display_no);
}

$grid=(12/$display_no);

$bss="tlp-col-md-".$grid." tlp-col-lg-".$grid." tlp-col-sm-6";


?>
<?php if($layout=='layout3'){ ?>
<div class="container-fluid">
	<div class="tlp-row tlp-portfolio">
		<div class="<?php echo $layout;?>">	
		<?php
			$this->tlpconfig= array(
					'image_storiage_path' => $image_storiage_path,
					'display_no' =>$display_no,
					'link_detail' => $link_detail,
					'grid' =>$grid
				);
			echo $this->loadTemplate($layout);
		?>
		</div>
	</div>
</div>

<?php }else{?>
<form action="<?php echo JRoute::_('index.php?option=com_tlpportfolio&view=portfolios'); ?>" method="post" name="adminForm" id="adminForm">
<div class="container-fluid">
<div class="tlp-row tlp-portfolio">
	<div class="<?php echo $layout;?>">	

		<?php foreach ($this->items as $i => $item) : ?>
			
			<div class="<?php echo $bss;?> margin-bottom30 ">
				<?php
					$this->item = & $item;
					$this->tlpconfig= array(
							'image_storiage_path' => $image_storiage_path,
							'display_no' =>$display_no,
							'link_detail' => $link_detail
						);
					echo $this->loadTemplate($layout);
				?>
			</div>	
		<?php endforeach; ?>
	</div>
</div>	
<div class="tlp-row">
	<?php echo $this->pagination->getListFooter(); ?>
</div>	
</div>
</form>
<?php }?>


<script src="<?php echo JURI::root();?>components/com_tlpportfolio/assets/js/imagesloaded.pkgd.min.js" type="text/javascript"></script>
<script src="<?php echo JURI::root();?>components/com_tlpportfolio/assets/js/isotope.pkgd.min.js" type="text/javascript"></script>
<style>
    .tlp-portfolio .tlp-portfolio-item:after{
        clear: both;
        display: block;
        content: "";
    }
</style>
<script type="text/javascript">

	(function($){
		var $isotop = $('.grid').imagesLoaded( function() {
			$isotop.isotope({
				  // options
				  itemSelector: '.tlp-portfolio-item',
				  layoutMode: 'fitRows'
				});
			});

		 $('.filter-button-group').on( 'click', 'button', function() {
		   var filterValue = $(this).attr('data-filter');
		   $isotop.isotope({ filter: filterValue });
		   $(this).parent().find('.selected').removeClass('selected');
		   $(this).addClass('selected'); 
		 });

        $( ".tlp-portfolio").imagesLoaded(function () {
            var maxH=0;
            $( ".tlp-portfolio .tlp-equal-height" ).each(function( ) {
                var cH = $(this).outerHeight();
                if(cH > maxH){
                    maxH = cH;
                }
                console.log(maxH);
            });

            $(".tlp-portfolio .tlp-equal-height" ).css('height',maxH+"px");
        });

		$('.tlp-item').each(function() {
	      var holder_height = $(this).height();
	      var a_height = $(this).find('.tlp-overlay .link-icon').height();
	      var h = (holder_height - a_height) / 2;
	      $(this).find('.link-icon').css('margin-top', h+'px');
	      }); 

	})(jQuery);

	</script>
	


