<?php

/**
 * @version    1.0.0
 * @package    com_tlpportfolio
 * @author     TechLabPro <mamunnu@gmail.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

/**
 * Class TlpportfolioFrontendHelper
 *
 * @since  1.6
 */
class TlpportfolioFrontendHelper
{
	/**
	* Get category name using category ID
	* @param integer $category_id Category ID
	* @return mixed category name if the category was found, null otherwise
	*/
	public static function getCategoryNameByCategoryId($category_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query
			->select('title')
			->from('#__categories')
			->where('id = ' . intval($category_id));

		$db->setQuery($query);
		return $db->loadResult();
	}
	/**
	 * Get Gategory for isotope
	 */
	public static function getCategoryName() {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query
			->select('id,title')
			->from('#__categories')
			->where('extension = "com_tlpportfolio"');
		//echo $query;
		$db->setQuery($query);
		return $db->loadobjectlist();
	}

	/**
	 * Get all profile for isotope
	 */
	public static function getallPortfolio() {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query
			->select('*')
			->from('#__tlpportfolio_portfolio')
			->where('state = 1')
			->orderby('ordering DESC');

		$db->setQuery($query);
		return $db->loadobjectlist();
	}
	/**
	 * Get an instance of the named model
	 *
	 * @param   string  $name  Model name
	 *
	 * @return null|object
	 */
	public static function getModel($name)
	{
		$model = null;

		// If the file exists, let's
		if (file_exists(JPATH_SITE . '/components/com_tlpportfolio/models/' . strtolower($name) . '.php'))
		{
			require_once JPATH_SITE . '/components/com_tlpportfolio/models/' . strtolower($name) . '.php';
			$model = JModelLegacy::getInstance($name, 'TlpportfolioModel');
		}

		return $model;
	}
}
