<?php
/**
* @package		Joomla & QuickForm
* @Copyright ((c) juice-lab.ru
* @license    GNU/GPL
*/

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

JHtml::_('behavior.formvalidator');
JHtml::_('behavior.keepalive');
$this->document->addScript( '//code.jquery.com/ui/1.11.4/jquery-ui.min.js', 'text/javascript');

JFactory::getDocument()->addScriptDeclaration("
		Joomla.submitbutton = function(task)
		{
			if (task == 'addfild')
			{
				return false;
			}
			else if (task == 'form.cancel' || document.formvalidator.isValid(document.getElementById('form-form')))
			{
				QuickForm.submitform(task, document.getElementById('form-form'));
			}
		};
");
?>
<form action="<?php echo JRoute::_('index.php?option=com_quickform&layout=edit&id=' . (int) $this->item->id); ?>" method="post" name="adminForm" id="form-form" class="form-validate form-horizontal">
	<div class="form-horizontal">
		<div class="row-fluid">
			<div class="span9">
				<?php
					echo $this->form->getControlGroup('title');
				?>
			</div>
		</div>
	</div>
  <div class="formdiv">
    <table id="formtbl">
      <thead>
        <tr><th class="l_td">label:<br /></th><th class="r_td">teg:<br /></th><th class="atr_td"></th><th class="del_td"></th></tr>
      </thead>
      <tbody>
				<?php
				if($this->item->fields){
					$rows = json_decode($this->item->fields);
					$html = '';
					foreach($rows as $row){
						$label = isset($row->label)?$row->label:'';
						unset($row->label);
						$options = isset($row->options)?$row->options:'';
						unset($row->options);

						if($row->teg=='customHtml'){
							$inplab = '<textarea class="qflabelclass">'.$label.'</textarea>';
						}
						elseif($row->teg=='recaptcha' || $row->teg=='cloner' || $row->teg=='calcCondition'){
							$inplab = '<input type="hidden" value="" class="qflabelclass" />';
						}
						else{
							$calc = (isset($row->calculator) && $row->calculator)?' calc':'';
							$inplab = '<input name="qfllabel" type="text" value="'.$label.'" class="qflabelclass'.$calc.'" />';
						}

						$html .= '<tr data-settings="'.htmlentities(json_encode($row), ENT_QUOTES, 'UTF-8').'"><td class="l_td">'.$inplab;
						if($options){
							$html .= '<div class="optionsBox hid">';
							foreach($options as $option){
								$label = $option->label;
								unset($option->label);
								$calc = (isset($option->calculator) && $option->calculator)?' calc':'';
								$html .= '<div class="optionRow" data-settings="'.htmlentities(json_encode($option), ENT_QUOTES, 'UTF-8').'"><input name="qfoption" class="'.$calc.'" type="text" value="'.$label.'" /><a href="#" class="setting"><img src="components/com_quickform/assets/setting.png"></a><a href="#" class="plus"><img src="components/com_quickform/assets/plus.png"></a><a href="#" class="delete"><img src="components/com_quickform/assets/delete.png"></a></div>';
							}
							$html .= '</div>';
						}

						if($row->teg=='select' || $row->teg=='input[radio]')
							$teg = '<span class="smbtogl"></span> <a href="#" class="optionstogler">'.$row->teg.'</a>';
						else $teg = $row->teg;

						$req = (isset($row->required) && $row->required)?' req':'';

						$html .= '</td><td class="r_td'.$req.'">'.$teg.'</td><td class="atr_td"><a href="#"><img src="components/com_quickform/assets/setting.png"></a></td><td class="del_td"><a href="#"><img src="components/com_quickform/assets/delete.png"></a></td></tr>';
					}
					echo $html;
				}
        ?>
      </tbody>
    </table>
 </div>
	<input type="hidden" name="fields" value="" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="projectid" value="<?php echo $this->item->projectid ?>" />
	<?php echo JHtml::_('form.token'); ?>
</form>
