<?php
/**
 * @copyright	Copyright (c) 2013 Skyline Technology Ltd (http://extstore.com). All rights reserved.
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// No direct access.
defined('_JEXEC') or die;

/**
 * Advanced Portfolio Helper.
 *
 * @package		Joomla.Administrator
 * @subpackage	Skyline.Portfolio
 */
class AdvPortfolioHelper {
	/**
	 * Configure the Linkbar.
	 *
	 * @param	string	The name of the active view.
	 */
	public static function addSubmenu($vName = '') {
		JHtmlSidebar::addEntry(
			JText::_('COM_ADVPORTFOLIO_SUBMENU_DASHBOARD'),
			'index.php?option=com_advportfolio&view=dashboard',
			$vName == 'dashboard'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_ADVPORTFOLIO_SUBMENU_PROJECTS'),
			'index.php?option=com_advportfolio&view=projects',
			$vName == 'projects'
		);

		JHtmlSidebar::addEntry(
			JText::_('COM_ADVPORTFOLIO_SUBMENU_CATEGORIES'),
			'index.php?option=com_categories&extension=com_advportfolio',
			$vName == 'categories'
		);

//		JHtmlSidebar::addEntry(
//			JText::_('COM_ADVPORTFOLIO_SUBMENU_TAGS'),
//			'index.php?option=com_advportfolio&view=tags',
//			$vName == 'tags'
//		);

		if ($vName == 'categories') {
			JToolBarHelper::title(
				JText::sprintf('COM_CATEGORIES_CATEGORIES_TITLE', JText::_('COM_ADVPORTFOLIO')),
				'advportfolio-categories'
			);
		}
	}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @param	int		The category ID.
	 * @return	JObject
	 */
	public static function getActions($categoryId = 0) {
		$user	= JFactory::getUser();
		$result	= new JObject();

		if (empty($categoryId)) {
			$assetName	= 'com_advportfolio';
		} else {
			$assetName	= 'com_advportfolio.category.' . (int) $categoryId;
		}

		$actions	= array(
			'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete',
		);

		foreach ($actions as $action) {
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;
	}

	/**
	 * Format file size to display
	 * @param	int	$size
	 * @return	string
	 */
	public static function fileSize($size) {
		if ($size < 1024) {
			return JText::sprintf('%d bytes', $size);
		} else {
			if ($size > 1024 && $size < 1048576) {
				return JText::sprintf('%01.2f KB', $size / 1024.0);
			} else {
				return JText::sprintf('%01.2f MB', $size / 1048576.0);
			}
		}
	}

	/**
	 * Method to get value of images field.
	 *
	 * @params	string	$value	Raw data string.
	 * @return	array	Array of images.
	 */
	public static function getImages($value) {
		$items	= array();

		if (is_array($value)) {
			if (isset($value['image']) && count($value['image'])) {
				for ($i = 0, $n = count($value['image']); $i < $n; $i++) {
					$item			= new stdClass();
					$item->image	= $value['image'][$i];
					$item->title	= $value['title'][$i];

					if ($item->image) {
						$items[]		= $item;
					}
				}
			}
		} else if (is_object($value)) {
			if (isset($value->image) && count($value->image)) {
				for ($i = 0, $n = count($value->image); $i < $n; $i++) {
					$item			= new stdClass();
					$item->image	= $value->image[$i];
					$item->title	= $value->title[$i];

					if ($item->image) {
						$items[]		= $item;
					}
				}
			}
		}

		return $items;
	}
}