<?php
/**
* @package		Joomla & QuickForm
* @Copyright ((c) juice-lab.ru
* @license    GNU/GPL
*/

defined('_JEXEC') or die;

header ("Content-type: text/html; charset=utf-8");

$app = JFactory::getApplication();

if($app->input->get('task')=='ajax'){
	require_once JPATH_COMPONENT.'/helpers/ajax.php';
	exit;
}

require_once JPATH_COMPONENT.'/classes/buildletters.php';
$qfFilds = new qfFilds;

$qfFilds->qfcheckToken();

$msgtype = 'error';

if($_SERVER['HTTP_REFERER']) $link=$_SERVER['HTTP_REFERER'];
else $link='/';

$id = $app->input->get('id', 0, 'INT');

$project = $qfFilds->getProjectById($id);
if(empty($project)){
	$msg = JText::sprintf('COM_QF_NOT_PROJECT', $id);
	$app->redirect($link, $msg, $msgtype);
}

$html = $qfFilds->getResultHtml($project);

if(!$qfFilds->submited){
	$msg = JText::_('COM_QF_CANNOT_BE_SENT');
	$app->redirect($link, $msg, $msgtype);
}

if ($qfFilds->errormes) {
	$msg = implode('<br>', $qfFilds->errormes);
	$app->redirect($link, $msg, $msgtype);
}


$sent = $qfFilds->sendMail($project, $html);
if(!$sent){
	$msg = JText::_('COM_QF_EMAIL_WAS_NOT_SENT');
	$app->redirect($link, $msg, $msgtype);
}

$stat = $qfFilds->writeStat($project, $html);
if(!$stat){
	$msg = JText::_('COM_QF_NOT_COMPLETED');
	$app->redirect($link, $msg, $msgtype);
}

$msg = $qfFilds->mlangLabel($project->popmess);
$msgtype = 'message';

$app->redirect($link, $msg, $msgtype);
