<?php
/**
 * @package     Joomla.Platform
 * @subpackage  Form
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('_JEXEC') or die;
JFormHelper::loadFieldClass('calendar');

/**
 * Form Field class for the Joomla Platform.
 *
 * Provides a pop up date picker linked to a button.
 * Optionally may be filtered to use user's or server's time zone.
 *
 * @package     Joomla.Platform
 * @subpackage  Form
 * @since       11.1
 */
class JFormFieldVCalendar extends JFormFieldCalendar
{
    protected $type = 'VCalendar';

	/**
	 * Method to attach a JForm object to the field.
	 *
	 * @param   SimpleXMLElement  $element  The SimpleXMLElement object representing the <field /> tag for the form field object.
	 * @param   mixed             $value    The form field value to validate.
	 * @param   string            $group    The field name group control value. This acts as as an array container for the field.
	 *                                      For example if the field has name="foo" and the group value is set to "bar" then the
	 *                                      full field name would end up being "bar[foo]".
	 *
	 * @return  boolean  True on success.
	 *
	 * @see     JFormField::setup()
	 * @since   3.2
	 */
	public function setup(SimpleXMLElement $element, $value, $group = null)
	{
		$return = parent::setup($element, $value, $group);

		if ($return)
		{
            $model = new VisformsModelVisfield();
            $fieldid = $this->form->getValue('id', null, 0);
            $fieldconfig = $model->getItem($fieldid);
            if (!empty($fieldconfig->defaultvalue) && is_array($fieldconfig->defaultvalue) && !empty($fieldconfig->defaultvalue['f_date_format']))
            {
                $fldConfDateFormat = explode(';', $fieldconfig->defaultvalue['f_date_format']);
                if (is_array($fldConfDateFormat) && isset($fldConfDateFormat[1]))
                {
                    $this->format = $fldConfDateFormat[1];
                }
            }
            $jversion = new JVersion();
            if (version_compare($jversion->getShortVersion(), '3.7', 'ge'))
            {
                $this->showtime     = 'false';//(string) $this->element['showtime'] ? (string) $this->element['showtime'] : 'true';
                $this->filltable    =  'true';//(string) $this->element['filltable'] ? (string) $this->element['filltable'] : 'true';
            }
		}

		return $return;
	}
}
