<?php

/**
 * @version    CVS: 1.0.0
 * @package    Com_Tlpportfolio
 * @author     TechLabPro <mamunnu@gmail.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

/**
 * Tlpportfolio helper.
 *
 * @since  1.6
 */
class TlpportfolioHelper
{
	/**
	 * Configure the Linkbar.
	 *
	 * @param   string  $vName  string
	 *
	 * @return void
	 */
	public static function addSubmenu($vName = '')
	{
		JHtmlSidebar::addEntry(
			JText::_('COM_TLPPORTFOLIO_TITLE_PORTFOLIOS'),
			'index.php?option=com_tlpportfolio&view=portfolios',
			$vName == 'portfolios'
		);

		JHtmlSidebar::addEntry(
			JText::_('JCATEGORIES') . ' (' . JText::_('COM_TLPPORTFOLIO_TITLE_PORTFOLIOS') . ')',
			"index.php?option=com_categories&extension=com_tlpportfolio",
			$vName == 'categories'
		);
		if ($vName=='categories') {
			JToolBarHelper::title('TLP Portfolio: JCATEGORIES (COM_TLPPORTFOLIO_TITLE_PORTFOLIOS)');
		}

	}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @return    JObject
	 *
	 * @since    1.6
	 */
	public static function getActions()
	{
		$user   = JFactory::getUser();
		$result = new JObject;

		$assetName = 'com_tlpportfolio';

		$actions = array(
			'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
		);

		foreach ($actions as $action)
		{
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;
	}
}
